<?php

namespace Local;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Place extends Model 
{

    protected $table = 'local_places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function photos()
    {
        return $this->hasMany('LocationGeo', 'id', 'uri', 'picture');
    }

    public function videos()
    {
        return $this->hasMany('LocationGeo', 'id', 'src', 'picture', 'type');
    }

    public function links()
    {
        return $this->hasMany('LocationGeo', 'id', 'url');
    }

    public function products()
    {
        return $this->hasMany('LocationGeo', 'id', 'name', 'picture', 'link', 'price');
    }

}