<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocalZonesTable extends Migration {

	public function up()
	{
		Schema::create('local_zones', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('level', array('A1', 'A2', 'A3', 'A4', 'A5', 'A6', 'A7', 'A8', 'A9'));
			$table->string('zid');
			$table->string('parent');
			$table->string('hasc');
			$table->string('code');
			$table->smallInteger('geoname_id');
			$table->string('type')->nullable();
			$table->string('name');
			$table->mediumInteger('area');
			$table->mediumInteger('population')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('local_zones');
	}
}