<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 100);
			$table->string('name', 60);
			$table->string('mobile', 20);
			$table->enum('type', array('individual', 'company'));
			$table->string('password', 100);
			$table->string('api_token', 60);
			$table->enum('role', array('fan', 'admin', 'editor'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}