<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('OrderDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('base_currency_code');
			$table->decimal('base_discount_amount');
			$table->decimal('base_grand_total');
			$table->decimal('base_discount_tax_compensation_amount');
			$table->decimal('base_subtotal');
			$table->decimal('base_subtotal_incl_tax');
			$table->decimal('base_tax_amount');
			$table->decimal('base_total_due');
			$table->decimal('base_to_global_rate');
			$table->decimal('base_to_order_rate');
			$table->integer('billing_address_id');
			$table->decimal('discount_amount');
			$table->string('global_currency_code');
			$table->decimal('grand_total');
			$table->decimal('discount_tax_compensation_amount');
			$table->string('status');
			$table->decimal('subtotal');
			$table->decimal('subtotal_incl_tax');
			$table->decimal('tax_amount');
			$table->decimal('total_due');
			$table->integer('total_item_count');
			$table->integer('total_qty_ordered');
			$table->decimal('weight');
			$table->string('item_ids');
		});
	}

	public function down()
	{
		Schema::drop('OrderDetails');
	}
}