<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrainingApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('training_applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('name');
			$table->string('email');
			$table->string('phone');
			$table->string('relevant_phone');
			$table->string('iban');
			$table->integer('gender_id')->unsigned();
			$table->date('birthdate');
			$table->string('ssn');
			$table->date('ssn_issue_date');
			$table->string('number');
			$table->integer('ssn_district_id')->unsigned();
			$table->integer('school_district_id')->unsigned();
			$table->string('school_name');
			$table->integer('school_city_id')->unsigned();
			$table->integer('secondary_certificate_type_id')->unsigned();
			$table->decimal('secondary_gpa', 5,2);
			$table->decimal('aptitude_test_score', 5,2);
			$table->text('comment');
			$table->integer('company_id')->unsigned();
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('training_applications');
	}
}