<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('content_translations', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('contents')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('category_translations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('terms', function(Blueprint $table) {
			$table->foreign('taxonomy_id')->references('id')->on('taxonomies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('term_translations', function(Blueprint $table) {
			$table->foreign('term_id')->references('id')->on('terms')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('taxonomy_translations', function(Blueprint $table) {
			$table->foreign('taxonomy_id')->references('id')->on('taxonomies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('content_translations', function(Blueprint $table) {
			$table->dropForeign('content_translations_content_id_foreign');
		});
		Schema::table('category_translations', function(Blueprint $table) {
			$table->dropForeign('category_translations_category_id_foreign');
		});
		Schema::table('terms', function(Blueprint $table) {
			$table->dropForeign('terms_taxonomy_id_foreign');
		});
		Schema::table('term_translations', function(Blueprint $table) {
			$table->dropForeign('term_translations_term_id_foreign');
		});
		Schema::table('taxonomy_translations', function(Blueprint $table) {
			$table->dropForeign('taxonomy_translations_taxonomy_id_foreign');
		});
	}
}