<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('mst_tasks', function(Blueprint $table) {
			$table->foreign('work_cat_id')->references('id')->on('mst_work_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->foreign('employees_id')->references('id')->on('mst_employees')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->foreign('departments_id')->references('id')->on('mst_departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('mst_positions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_projects', function(Blueprint $table) {
			$table->foreign('clients_id')->references('id')->on('mst_clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_project_members', function(Blueprint $table) {
			$table->foreign('projects_id')->references('id')->on('trx_projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trx_project_members', function(Blueprint $table) {
			$table->foreign('employees_id')->references('id')->on('mst_employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('mst_tasks', function(Blueprint $table) {
			$table->dropForeign('mst_tasks_work_cat_id_foreign');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->dropForeign('trx_employees_employees_id_foreign');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->dropForeign('trx_employees_departments_id_foreign');
		});
		Schema::table('trx_employees', function(Blueprint $table) {
			$table->dropForeign('trx_employees_position_id_foreign');
		});
		Schema::table('trx_projects', function(Blueprint $table) {
			$table->dropForeign('trx_projects_clients_id_foreign');
		});
		Schema::table('trx_project_members', function(Blueprint $table) {
			$table->dropForeign('trx_project_members_projects_id_foreign');
		});
		Schema::table('trx_project_members', function(Blueprint $table) {
			$table->dropForeign('trx_project_members_employees_id_foreign');
		});
	}
}