<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nickname', 32)->nullable()->index();
			$table->enum('gender', array('male', 'female'))->index();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}