<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('articles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_keyword', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('keywords')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_attribute', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('item_attribute', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_article_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_item_id_foreign');
		});
		Schema::table('item_keyword', function(Blueprint $table) {
			$table->dropForeign('item_keyword_item_id_foreign');
		});
		Schema::table('item_keyword', function(Blueprint $table) {
			$table->dropForeign('item_keyword_keyword_id_foreign');
		});
		Schema::table('item_attribute', function(Blueprint $table) {
			$table->dropForeign('item_attribute_item_id_foreign');
		});
		Schema::table('item_attribute', function(Blueprint $table) {
			$table->dropForeign('item_attribute_attribute_id_foreign');
		});
	}
}