<?php

namespace Item;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getProduct()
	{
		return $this->belongsTo('Item', 'product_id');
	}

	public function getArticle()
	{
		return $this->belongsTo('Item', 'article_id');
	}

	public function getImages()
	{
		return $this->hasMany('Item');
	}

	public function getKeywords()
	{
		return $this->belongsToMany('Item');
	}

	public function getAttributes()
	{
		return $this->belongsToMany('Item');
	}

}