<?php

namespace Item;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getProduct()
    {
        return $this->belongsTo('Item', 'product_id');
    }

    public function getArticle()
    {
        return $this->belongsTo('Item', 'article_id');
    }

    public function getImages()
    {
        return $this->hasMany('Item');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('Item');
    }

    public function getAttributes()
    {
        return $this->belongsToMany('Item');
    }

}