<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFundsTable extends Migration {

	public function up()
	{
		Schema::create('funds', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('fund_type_id')->unsigned();
			$table->string('name')->unique();
			$table->bigInteger('country_id')->unsigned();
			$table->string('currency');
			$table->date('closing_date');
			$table->string('name_documentation_file')->nullable();
			$table->string('mime_type_documentation_file')->nullable();
			$table->binary('data_documentation_file')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('funds');
	}
}