<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExplanationsTable extends Migration {

	public function up()
	{
		Schema::create('explanations', function(Blueprint $table) {
			$table->increments('id');
			$table->text('explanation');
			$table->integer('sum')->nullable();
			$table->float('inf_limit')->nullable();
			$table->float('sup_limit')->nullable();
			$table->string('identifier')->nullable();
			$table->integer('test_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('explanations');
	}
}