<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('last_name');
			$table->string('photo')->nullable();
			$table->integer('privilege');
			$table->string('email')->unique();
			$table->string('password');
			$table->rememberToken();
			$table->string('phone')->nullable();
			$table->string('mobile')->nullable();
			$table->string('profession')->nullable();
			$table->string('level1')->nullable();
			$table->string('level2')->nullable();
			$table->string('level3')->nullable();
			$table->string('position')->nullable();
			$table->string('company_name')->nullable();
			$table->string('country_name')->nullable();
			$table->string('city_name')->nullable();
			$table->string('type_user')->default('default');
			$table->text('coach_info')->nullable();
			$table->string('status')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->text('notes')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->integer('project_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}