<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVideosTable extends Migration {

	public function up()
	{
		Schema::create('videos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('video_name');
			$table->tinyInteger('is_full')->default('1');
			$table->integer('part')->default('1');
			$table->string('url_video')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->string('video_file')->nullable();
			$table->integer('lesson_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('videos');
	}
}