<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'content', 'user_id', 'popular');

	public function tags()
	{
		return $this->belongsToMany('App\Tag')->withTimestamps();
	}

}