<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('address');
			$table->string('email');
			$table->string('phone');
			$table->string('facebook');
			$table->string('instagram');
			$table->string('whatsapp');
			$table->string('fax');
			$table->string('twitter');
			$table->double('longitude', 10,8);
			$table->double('latitude', 10,8);
			$table->string('title');
			$table->text('content');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}