<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subscription extends Eloquent {

	protected $table = 'subscription';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'tower_id', 'package_id', 'first_invoice', 'status', 'user_id');

	public function tower()
	{
		return $this->belongsTo('Tower', 'tower_id');
	}

	public function client()
	{
		return $this->belongsTo('User', 'client_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function package()
	{
		return $this->belongsTo('Package', 'package_id');
	}

	public function invoices()
	{
		return $this->hasMany('Invoice', 'subscription_id');
	}

	public function histories()
	{
		return $this->hasMany('SubscriptionHistory', 'subscription_id');
	}

}