<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoicePayment extends Model 
{

    protected $table = 'invoice_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('invoice_id', 'amount', 'user_id', 'note');

    public function invoice()
    {
        return $this->belongsTo('Invoice', 'invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}