<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRefundsTable extends Migration {

	public function up()
	{
		Schema::create('refunds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('transaction_id')->unsigned()->index();
			$table->decimal('pourcent');
			$table->string('state', 255)->default('PENDING');
		});
	}

	public function down()
	{
		Schema::drop('refunds');
	}
}