<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Refund extends Eloquent {

	protected $table = 'refunds';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'transaction_id', 'pourcent', 'state');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function transaction()
	{
		return $this->belongsTo('App\Transaction');
	}

}