<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'starts_at', 'ends_at', 'user_id');

	public function transactions()
	{
		return $this->hasMany('App\Transaction');
	}

	public function users()
	{
		return $this->belongsToMany('App\User');
	}

}