<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMoreRefineSearchTable extends Migration {

	public function up()
	{
		Schema::create('more_refine_search', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_survey_profile_id')->unsigned();
			$table->bigInteger('school_id')->unsigned()->nullable();
			$table->string('location_address', 1000)->nullable();
			$table->string('location_lat', 255)->nullable();
			$table->string('location_long', 255)->nullable();
			$table->string('travel_time', 1000)->nullable();
			$table->boolean('is_bus')->default(false);
			$table->boolean('is_tram')->default(false);
			$table->boolean('is_train')->default(false);
			$table->integer('garage')->nullable();
			$table->string('storey', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('more_refine_search');
	}
}