<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetCountriesTable extends Migration {

	public function up()
	{
		Schema::create('set_countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('country')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->bigInteger('create_user_id')->unsigned();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('set_countries');
	}
}