<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username')->nullable();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('first_name');
			$table->string('last_name');
			$table->boolean('is_active')->default(1);
			$table->softDeletes();
			$table->string('phone')->nullable();
			$table->string('emergency_contact')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}