<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('dossiers', function(Blueprint $table) {
			$table->foreign('campagne_id')->references('id')->on('campagnes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dossiers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->foreign('dossier_id')->references('id')->on('dossiers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->foreign('centre_id')->references('id')->on('centre_recrutement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->foreign('recruteur_id')->references('id')->on('recruteurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('dossiers', function(Blueprint $table) {
			$table->dropForeign('dossiers_campagne_id_foreign');
		});
		Schema::table('dossiers', function(Blueprint $table) {
			$table->dropForeign('dossiers_user_id_foreign');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->dropForeign('agrements_dossier_id_foreign');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->dropForeign('agrements_centre_id_foreign');
		});
		Schema::table('agrements', function(Blueprint $table) {
			$table->dropForeign('agrements_recruteur_id_foreign');
		});
	}
}