<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Department extends Model 
{

    protected $table = 'departments';
    public $timestamps = true;

    public function municipalities()
    {
        return $this->hasMany('Municipality');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function programs()
    {
        return $this->hasMany('Program');
    }

    public function user()
    {
        return $this->hasOne('User');
    }

}