<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('purchasing_price', 50);
			$table->string('sell_price', 50);
			$table->string('picture', 255);
			$table->integer('category_id')->index();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}