<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoriesTable extends Migration {

	public function up()
	{
		Schema::create('stories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->integer('epic_id');
			$table->string('name');
			$table->text('desc');
			$table->datetime('starting_date');
			$table->datetime('expected_finish_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stories');
	}
}