<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('question_answer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_answer', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->foreign('question_type_id')->references('id')->on('question_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->foreign('question_list_id')->references('id')->on('question_list')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->foreign('previous_question_list_question_id')->references('id')->on('question_list_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_request', function(Blueprint $table) {
			$table->foreign('question_list_id')->references('id')->on('question_list')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_request_answer', function(Blueprint $table) {
			$table->foreign('question_request_id')->references('id')->on('question_request')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_request_answer', function(Blueprint $table) {
			$table->foreign('question_list_question_id')->references('id')->on('question_list_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_condition', function(Blueprint $table) {
			$table->foreign('question_list_question_id')->references('id')->on('question_list_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_group', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('question_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_qroup_question', function(Blueprint $table) {
			$table->foreign('question_group_id')->references('id')->on('question_group')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_qroup_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('question_answer', function(Blueprint $table) {
			$table->dropForeign('question_answer_question_id_foreign');
		});
		Schema::table('question_answer', function(Blueprint $table) {
			$table->dropForeign('question_answer_answer_id_foreign');
		});
		Schema::table('question', function(Blueprint $table) {
			$table->dropForeign('question_question_type_id_foreign');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->dropForeign('question_list_question_question_list_id_foreign');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->dropForeign('question_list_question_question_id_foreign');
		});
		Schema::table('question_list_question', function(Blueprint $table) {
			$table->dropForeign('question_list_question_previous_question_list_question_id_foreign');
		});
		Schema::table('question_request', function(Blueprint $table) {
			$table->dropForeign('question_request_question_list_id_foreign');
		});
		Schema::table('question_request_answer', function(Blueprint $table) {
			$table->dropForeign('question_request_answer_question_request_id_foreign');
		});
		Schema::table('question_request_answer', function(Blueprint $table) {
			$table->dropForeign('question_request_answer_question_list_question_id_foreign');
		});
		Schema::table('question_condition', function(Blueprint $table) {
			$table->dropForeign('question_condition_question_list_question_id_foreign');
		});
		Schema::table('question_group', function(Blueprint $table) {
			$table->dropForeign('question_group_parent_id_foreign');
		});
		Schema::table('question_qroup_question', function(Blueprint $table) {
			$table->dropForeign('question_qroup_question_question_group_id_foreign');
		});
		Schema::table('question_qroup_question', function(Blueprint $table) {
			$table->dropForeign('question_qroup_question_question_id_foreign');
		});
	}
}