<?php

namespace App;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	public function store()
	{
		return $this->belongsTo('App\Store');
	}

	public function consignments()
	{
		return $this->hasMany('App\Consignment');
	}

	public function customer()
	{
		return $this->hasOne('App\Customer');
	}

	public function actions()
	{
		return $this->hasMany('App\OrderAction');
	}

}