<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientAccount extends Eloquent {

	protected $table = 'client_account';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'client_id', 'value');

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}