<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('conjoint_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('oauths', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('profils', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('diplomes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cotisations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_conjoint_id_foreign');
		});
		Schema::table('oauths', function(Blueprint $table) {
			$table->dropForeign('oauths_user_id_foreign');
		});
		Schema::table('profils', function(Blueprint $table) {
			$table->dropForeign('profils_user_id_foreign');
		});
		Schema::table('diplomes', function(Blueprint $table) {
			$table->dropForeign('diplomes_user_id_foreign');
		});
		Schema::table('cotisations', function(Blueprint $table) {
			$table->dropForeign('cotisations_user_id_foreign');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->dropForeign('inscriptions_user_id_foreign');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->dropForeign('inscriptions_evenement_id_foreign');
		});
	}
}