<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->rememberToken('rememberToken');
			$table->string('email')->unique()->nullable();
			$table->string('password')->nullable();
			$table->boolean('admin');
			$table->boolean('suspended')->default(0);
			$table->integer('conjoint_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}