<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFarmsTable extends Migration {

	public function up()
	{
		Schema::create('farms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned()->nullable();
			$table->boolean('is_company')->default(0);
			$table->integer('all_farm_company_id');
			$table->string('type');
			$table->string('name');
			$table->string('code');
			$table->string('common_name');
			$table->string('email');
			$table->string('phone');
			$table->string('reg_number');
			$table->string('tax_number');
			$table->text('note');
			$table->string('identifier');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('farms');
	}
}