<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReceiptsTable extends Migration {

	public function up()
	{
		Schema::create('receipts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('number');
			$table->string('date');
			$table->string('currency');
			$table->integer('days_to_pay');
			$table->string('deliver_by');
			$table->string('responsible');
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->string('supplier_display');
			$table->string('deliver_by_date');
			$table->integer('transport_cost');
			$table->integer('vat_percent');
			$table->integer('vat');
			$table->integer('total_cost');
			$table->text('note');
			$table->string('obs');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('receipts');
	}
}