<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('description');
			$table->boolean('active')->default(0);
			$table->text('detailed_description');
			$table->integer('tax_number');
			$table->string('contact_person');
			$table->string('phone');
			$table->string('email');
			$table->string('other_info');
			$table->integer('address_id')->unsigned()->nullable();
			$table->integer('item_id')->unsigned()->nullable();
			$table->integer('contract_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}