<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('street');
			$table->string('zip_code');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->integer('holding_id')->unsigned()->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->string('farm_id')->nullable();
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}