<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->string('name');
			$table->string('type');
			$table->string('minumum_stoc');
			$table->string('warranty');
			$table->string('special_discount');
			$table->string('maximum_discount');
			$table->string('primary_um');
			$table->string('net_weight');
			$table->string('gross_weight');
			$table->string('width');
			$table->string('height');
			$table->string('depth');
			$table->string('um');
			$table->string('sup_discount');
			$table->string('transport');
			$table->string('customs');
			$table->string('direct_costs');
			$table->string('sale_price');
			$table->string('currency');
			$table->text('description');
			$table->string('image_url');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}