<?php

namespace Modules\User\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function parent()
	{
		return $this->belongsTo('Message', 'message_id');
	}

	public function replies()
	{
		return $this->hasMany('Message', 'message_id');
	}

}