<?php

namespace App\Models;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;
	protected $fillable = array('name_ar', 'name_en', 'type_ar', 'type_en', 'description_ar', 'description_en', 'link', 'is_approved', 'lat', 'lng', 'client_id');

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function offers()
	{
		return $this->hasMany('App\Models\Offer');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

}