<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('organization_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('driver_id')->unsigned();
			$table->enum('type', array(''delivery'', ''pickup'', ''combo''));
			$table->integer('lineItems');
			$table->enum('isOversize', array(''no'', ''yes''));
			$table->text('comments');
			$table->enum('status', array(''0'', ''1'', ''2'', ''3''));
			$table->integer('overallCapacity');
			$table->double('invoiceAmount');
			$table->datetime('pickupETA');
			$table->datetime('DeliveryETA');
			$table->enum('rating', array(''1'', ''2'', ''3'', ''4'', ''5''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}