<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('organization_id')->unsigned();
			$table->string('invoiceNo', 50);
			$table->datetime('invoiceTo');
			$table->datetime('invoiceFrom');
			$table->float('tax');
			$table->double('amount');
			$table->enum('status', array(''paid'', ''unpaid''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}