<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrganizationDetails extends Eloquent {

	protected $table = 'organization_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function organizations()
	{
		return $this->belongsTo('Organization', 'organization_id');
	}

	public function rebates()
	{
		return $this->belongsTo('Rebate', 'rebate_id');
	}

	public function pricings()
	{
		return $this->belongsTo('Pricing', 'pricing_id');
	}

}