<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Model 
{

    protected $table = 'drivers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function vehicles()
    {
        return $this->belongsTo('Vehicle', 'vehicle_id');
    }

}