<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfilesTable extends Migration {

	public function up()
	{
		Schema::create('user_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('profileImage', 50);
			$table->date('dob');
			$table->string('licenceNo', 50);
			$table->string('city', 50);
			$table->string('state', 50);
			$table->integer('zipcode');
			$table->string('homePhone', 20);
			$table->string('emgContactName', 50);
			$table->string('emgContactNo', 20);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_profiles');
	}
}