<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname', 50);
			$table->rememberToken('rememberToken');
			$table->string('lastname', 50);
			$table->string('email', 50);
			$table->string('password', 100);
			$table->string('phone');
			$table->enum('phoneVerify', array(''0'', ''1''));
			$table->string('verificationCode', 10);
			$table->enum('status', array(''0'', ''1''));
			$table->integer('user_organization_id');
			$table->string('primaryRole', 20);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}