<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('organization_id')->unsigned();
			$table->string('mainContact', 50);
			$table->string('street', 50);
			$table->string('city', 50);
			$table->string('state', 50);
			$table->integer('zipcode');
			$table->string('email', 50);
			$table->string('website', 100);
			$table->date('m_f_start');
			$table->date('m_f_end');
			$table->date('sat_start');
			$table->date('sat_end');
			$table->date('sun_start');
			$table->date('sun_end');
			$table->enum('accountType', array(''check'', ''card'', ''cash''));
			$table->enum('accountStanding', array(''good'', ''bad''));
			$table->enum('status', array(''0'', ''1''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}