<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('uuid');
			$table->integer('guest_id')->unsigned();
			$table->date('date_from');
			$table->date('date_to');
			$table->decimal('total_price', 6,2);
			$table->integer('payment_id')->unsigned();
			$table->integer('number_rooms');
			$table->integer('reservation_status_id')->unsigned();
			$table->string('created_by');
			$table->string('updated_by');
			$table->string('reservation_type_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}