<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('guests', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('guests', function(Blueprint $table) {
			$table->foreign('type_documentation_id')->references('id')->on('type_documentation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('guest_id')->references('id')->on('guests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('reservation_status_id')->references('id')->on('reservation_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reser_room', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reser_room', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('room_type_id')->references('id')->on('room_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_amanities', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_amanities', function(Blueprint $table) {
			$table->foreign('amantities_id')->references('id')->on('amanities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('room_photos', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('guests', function(Blueprint $table) {
			$table->dropForeign('guests_person_id_foreign');
		});
		Schema::table('guests', function(Blueprint $table) {
			$table->dropForeign('guests_type_documentation_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_guest_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_reservation_status_id_foreign');
		});
		Schema::table('reser_room', function(Blueprint $table) {
			$table->dropForeign('reser_room_reservation_id_foreign');
		});
		Schema::table('reser_room', function(Blueprint $table) {
			$table->dropForeign('reser_room_room_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_room_type_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_person_id_foreign');
		});
		Schema::table('room_amanities', function(Blueprint $table) {
			$table->dropForeign('room_amanities_room_id_foreign');
		});
		Schema::table('room_amanities', function(Blueprint $table) {
			$table->dropForeign('room_amanities_amantities_id_foreign');
		});
		Schema::table('room_photos', function(Blueprint $table) {
			$table->dropForeign('room_photos_room_id_foreign');
		});
	}
}